/*
 * Decompiled with CFR 0.152.
 */
package com.skloch.game.scoring;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class Achievement {
    private Map<Integer, AchievementEntry> achievements = new HashMap<Integer, AchievementEntry>();
    private static final Achievement instance = new Achievement();
    private int scoreGainedPer = 100;

    public Achievement() {
        this.addAchievement(1, "Tree?", "Talk to the mysterious tree.");
        this.addAchievement(2, "Bookworm", "Study at least 4 times this week.");
        this.addAchievement(3, "Duck duck go!", "Feed the ducks at least 6 times.");
        this.addAchievement(4, "Jogger", "Go for a walk every day during the week");
    }

    public static Achievement getInstance() {
        return instance;
    }

    private void addAchievement(int id, String name, String desc) {
        this.achievements.put(id, new AchievementEntry(id, name, desc));
    }

    public void giveAchievement(int id) {
        AchievementEntry achievement = this.achievements.get(id);
        if (achievement != null && !achievement.isAchieved()) {
            achievement.setAchieved(true);
        }
    }

    public void resetAllAchievements() {
        for (AchievementEntry achievement : this.achievements.values()) {
            achievement.setAchieved(false);
        }
    }

    public String getUserAchievements() {
        return this.achievements.values().stream().filter(AchievementEntry::isAchieved).map(achievement -> "- " + achievement.getName() + " +" + this.scoreGainedPer + ": " + achievement.getDesc() + "\n").collect(Collectors.joining());
    }

    public boolean checkAchievement(int id) {
        AchievementEntry achievement = this.achievements.get(id);
        if (achievement != null) {
            return achievement.isAchieved();
        }
        return false;
    }

    public boolean bookwormAchievement(int studyCount) {
        if (studyCount >= 4 && !Achievement.getInstance().checkAchievement(2)) {
            Achievement.getInstance().giveAchievement(2);
            return true;
        }
        return false;
    }

    public boolean duckDuckGoAchievement(int duckCount) {
        if (duckCount >= 6 && !Achievement.getInstance().checkAchievement(3)) {
            Achievement.getInstance().giveAchievement(3);
            return true;
        }
        return false;
    }

    public boolean joggerAchievement(int walkCount) {
        if (walkCount >= 7 && !Achievement.getInstance().checkAchievement(4)) {
            Achievement.getInstance().giveAchievement(4);
            return true;
        }
        return false;
    }

    public class AchievementEntry {
        private int id;
        private String name;
        private String desc;
        private boolean achieved;

        public AchievementEntry(int id, String name, String desc) {
            this.id = id;
            this.name = name;
            this.desc = desc;
            this.achieved = false;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getDesc() {
            return this.desc;
        }

        public boolean isAchieved() {
            return this.achieved;
        }

        public void setAchieved(boolean achieved) {
            this.achieved = achieved;
        }
    }
}

